//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Create 1.0
import wesual.Stage  1.0
import wesual.Ui     1.0

SizeIcon {
    id : deviceIcon

    property DeviceStatus deviceStatus

    readonly property DisplayDevice device :
        deviceStatus ? deviceStatus.device : null

    readonly property bool isNew :
        device ? !!(device.statusFlags & DisplayDevice.NewlyAdded) : false
    readonly property bool showIndicator : isNew

    size : deviceStatus.displaySize

    layer.smooth : true
    layer.enabled : showIndicator
    layer.effect : ShaderEffect {
        property Image mask : maskSrc
        property Image indicator : indicatorSrc

        fragmentShader :
          "varying highp vec2 qt_TexCoord0;" +
          "uniform sampler2D source;" +
          "uniform sampler2D mask;" +
          "uniform sampler2D indicator;" +
          "uniform lowp float qt_Opacity;" +
          "void main() {" +
              "lowp vec4 tex = texture2D(source, qt_TexCoord0);" +
              "lowp float mask = texture2D(mask, qt_TexCoord0).r;" +
              "lowp vec4 indicator = texture2D(indicator, qt_TexCoord0);" +
              "gl_FragColor = mix(indicator, tex, mask)" +
                  "* qt_Opacity;" +
          "}"
    }

    children : [
        Image {
            id : indicatorSrc

            source : {
                if (isNew) {
                    return "qrc:/create/lib/images/new-device-indicator.png";
                } else {
                    return "";
                }
            }
            visible : false
        },
        Image {
            id : maskSrc

            source : showIndicator
                     ? "qrc:/create/lib/images/new-device-mask.png"
                     : ""
            visible : false
        }
    ]
}
